; Configuration file for Fly-E3 (firmware version 3)
; executed by the firmware on start-up
;
; generated by RepRapFirmware Configuration Tool v3.2.1-LPC on Fri Mar 12 2021 17:16:59 GMT+0100 (Central European Standard Time)

; General preferences
G90                                             ; send absolute coordinates...
M83                                             ; ...but relative extruder moves
M550 P"Ender-3"                                 ; set printer name

; Network
M552 S1                                        ; enable network
M586 P0 S1                                     ; enable HTTP
M586 P1 S1                                     ; enable FTP
M586 P2 S0                                     ; disable Telnet

; Drives
M569 P0 S0  D3 V40                             ; X physical drive 0 goes backwards using default driver timings
M569 P1 S0  D3 V40                             ; Y physical drive 1 goes backwards using default driver timings
M569 P2 S1                                     ; Z physical drive 2 goes forwards using default driver timings
M569 P3 S0                                     ; E physical drive 3 goes forwards using default driver timings
M584 X0 Y1 Z2 E3                               ; set drive mapping
M350 X16 Y16 Z16 E16 I1                        ; configure microstepping with interpolation
M92 X80.00 Y80.00 Z400.00 E93.00               ; set steps per mm

; Speeds
M566 X1200.00 Y1200.00 Z60.00 E360.00          ; set maximum instantaneous speed changes (mm/min)
M203 X9000.00 Y9000.00 Z300.00 E1560.00       ; set maximum speeds (mm/min)
M201 X500.00 Y500.00 Z100.00 E1000.00          ; set accelerations (mm/s^2)

; Motor Currents
M906 X800 Y800 Z800 E1000 I30               ; set motor currents (mA) and motor idle factor in per cent X and Y was 1200
M84 S30                                        ; Set idle timeout

; Axis Limits
M208 X0 Y0 Z0 S1                               ; set axis minima
M208 X235 Y235 Z260 S0                         ; set axis maxima

; Endstops
M574 X1 S3                                     ; configure sensorless endstop for low end on X
M574 Y1 S3                                     ; configure sensorless endstop for low end on Y
M915 P0 S12 H150 R0		    				   ; Sensorless Homing X 
M915 P1 S12 H150 R0  					   	   ; Sensorless Homing Y
M574 Z1 S1 P"zstop"							   ; Z-end stop, optical

; Z-Probe
;M574 Z1 S2                                    ; configure Z-probe endstop for low end on Z
;M558 P5 C"!^probe" H5 F120 T6000              ; set Z probe type to switch and the dive height + speeds
;G31 P500 X-38.5 Y0 Z1.19                      ; set Z probe trigger value, offset and trigger height
;M557 X5:198 Y10:210 S40                       ; define mesh grid

; Heaters
M308 S0 P"bedtemp" Y"thermistor" T100000 B4725 C7.060000e-8 R4700  ; BED Define Bed temp sensor
M308 S1 P"e0_temp" Y"thermistor" T100000 B4725 C7.060000e-8 R4700   ; HOTEND Define E0 temp sensor
M950 H0 C"bed" Q100 T0 										; BED heater 0 uses the bed_heat pin, sensor 0, PWM 100Hz
M950 H1 C"e0_heat" Q100 T1 											; HOTEND heater 1 uses the e0_heat pin and sensor 1, PWM 100Hz
M307 H0 A152.5 C477.6 D0.5 S1.00 V24.2 B0							; BED Heated Bed PID values, Disabled BangBang							
M307 H1 A335.4 C122.5 D4.0 S1.00 V24.3 B0							; HOTEND  HotEnd PID values, Disabled BangBang
M140 H0 								 							; BED the bed heater is heater 0
M143 H0 S130                             							; BED set temperature limit for heater 0 to 130C
M143 H1 S275                            							; HOTEND set temperature limit for heater 1 to 275C                                 ; set temperature limit for heater 1 to 245C

; Fans
M950 F0 C"fan0" Q500                           ; create fan 0 on pin fan0 and set its frequency
M106 P0 C"Part Cooling Fan" S0 H-1             ; set fan 0 name and value. Thermostatic control is turned off
M950 F1 C"fan1" Q500                           ; create fan 1 on pin fan1 and set its frequency
M106 P1 C"Hotend Fan" S0.01 H1 T45             ; set fan 1 name and value. Thermostatic control is turned on

; Tools
M563 P0 D0 H1 F0                               ; define tool 0
G10 P0 X0 Y0 Z0                                ; set tool 0 axis offsets
G10 P0 R0 S0                                   ; set initial tool 0 active and standby temperatures to 0C

; Custom settings
; 12864 Stock Display
M918 P1 E-4 F1000000							; Enable the stock Ender-3 Display

; Miscellaneous
M501                                           ; load saved parameters from non-volatile memory

